<?= $this->extend('layouts/main') ?>
<?= $this->section('content') ?>
<h3>Task Detail</h3>
<div class="card">
    <div class="card-body">
        <p><strong>Title:</strong> <?= esc($task['title']) ?></p>
        <p><strong>Project:</strong> <?= esc($task['project_name']) ?></p>
        <p><strong>Customer:</strong> <?= esc($task['company_name']) ?></p>
        <p><strong>Service Type:</strong> <?= esc($task['service_type_name']) ?></p>
        <p><strong>Description:</strong><br><?= nl2br(esc($task['description'])) ?></p>
        <p><strong>Priority:</strong> <?= esc($task['priority']) ?> | <strong>Due:</strong> <?= esc($task['due_date']) ?></p>

        <form method="post" action="/staff/tasks/<?= esc($task['id']) ?>/status" class="row g-2">
            <?= csrf_field() ?>
            <div class="col-md-4">
                <select class="form-select" name="status">
                    <?php foreach (['todo', 'doing', 'done'] as $s): ?>
                        <option value="<?= esc($s) ?>" <?= $task['status'] === $s ? 'selected' : '' ?>><?= esc($s) ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="col-md-4"><button class="btn btn-success">Update Status</button></div>
            <div class="col-md-4"><a class="btn btn-secondary" href="/staff/my-tasks">Back</a></div>
        </form>
    </div>
</div>
<?= $this->endSection() ?>
