<?= $this->extend('layouts/main') ?>
<?= $this->section('content') ?>
<div class="d-flex justify-content-between mb-3">
    <h3>Tasks</h3>
    <a class="btn btn-primary" href="/admin/tasks/create">New Task</a>
</div>

<form method="get" class="row g-2 mb-3">
    <div class="col-md-3">
        <select class="form-select" name="status">
            <option value="">Status</option>
            <?php foreach (['todo', 'doing', 'done'] as $s): ?>
                <option value="<?= esc($s) ?>" <?= service('request')->getGet('status') === $s ? 'selected' : '' ?>><?= esc($s) ?></option>
            <?php endforeach; ?>
        </select>
    </div>
    <div class="col-md-3">
        <select class="form-select" name="assignee">
            <option value="">Assignee</option>
            <?php foreach ($staff as $u): ?>
                <option value="<?= esc($u['id']) ?>" <?= service('request')->getGet('assignee') == $u['id'] ? 'selected' : '' ?>><?= esc($u['name']) ?></option>
            <?php endforeach; ?>
        </select>
    </div>
    <div class="col-md-3">
        <select class="form-select" name="project">
            <option value="">Project</option>
            <?php foreach ($projects as $p): ?>
                <option value="<?= esc($p['id']) ?>" <?= service('request')->getGet('project') == $p['id'] ? 'selected' : '' ?>><?= esc($p['name']) ?></option>
            <?php endforeach; ?>
        </select>
    </div>
    <div class="col-md-3"><button class="btn btn-outline-primary w-100">Filter</button></div>
</form>

<table class="table table-bordered">
    <thead><tr><th>ID</th><th>Title</th><th>Project</th><th>Service</th><th>Assignee</th><th>Status</th><th>Due</th><th>Action</th></tr></thead>
    <tbody>
    <?php foreach ($tasks as $t): ?>
        <tr>
            <td><?= esc($t['id']) ?></td>
            <td><?= esc($t['title']) ?></td>
            <td><?= esc($t['project_name']) ?></td>
            <td><?= esc($t['service_type_name']) ?></td>
            <td><?= esc($t['assignee_name']) ?></td>
            <td><?= esc($t['status']) ?></td>
            <td><?= esc($t['due_date']) ?></td>
            <td><a class="btn btn-sm btn-warning" href="/admin/tasks/<?= esc($t['id']) ?>/edit">Edit</a></td>
        </tr>
    <?php endforeach; ?>
    </tbody>
</table>
<?= $this->endSection() ?>
