<?= $this->extend('layouts/main') ?>
<?= $this->section('content') ?>
<h3><?= isset($task) && $task ? 'Edit Task' : 'Create Task' ?></h3>
<form method="post">
    <?= csrf_field() ?>
    <div class="row">
        <div class="col-md-6 mb-2">
            <label>Project</label>
            <select class="form-select" name="project_id" required>
                <option value="">Select</option>
                <?php foreach ($projects as $p): ?>
                    <option value="<?= esc($p['id']) ?>" <?= old('project_id', $task['project_id'] ?? '') == $p['id'] ? 'selected' : '' ?>><?= esc($p['name']) ?></option>
                <?php endforeach; ?>
            </select>
        </div>
        <div class="col-md-6 mb-2"><label>Title</label><input class="form-control" name="title" value="<?= esc(old('title', $task['title'] ?? '')) ?>" required></div>
        <div class="col-md-12 mb-2"><label>Description</label><textarea class="form-control" name="description"><?= esc(old('description', $task['description'] ?? '')) ?></textarea></div>
        <div class="col-md-4 mb-2">
            <label>Service Type</label>
            <select class="form-select" name="service_type_id" required>
                <option value="">Select</option>
                <?php foreach ($serviceTypes as $s): ?>
                    <option value="<?= esc($s['id']) ?>" <?= old('service_type_id', $task['service_type_id'] ?? '') == $s['id'] ? 'selected' : '' ?>><?= esc($s['name']) ?></option>
                <?php endforeach; ?>
            </select>
        </div>
        <div class="col-md-4 mb-2">
            <label>Priority</label>
            <select class="form-select" name="priority">
                <?php foreach (['low', 'medium', 'high'] as $p): ?>
                    <option value="<?= esc($p) ?>" <?= old('priority', $task['priority'] ?? 'medium') === $p ? 'selected' : '' ?>><?= esc($p) ?></option>
                <?php endforeach; ?>
            </select>
        </div>
        <div class="col-md-4 mb-2">
            <label>Status</label>
            <select class="form-select" name="status">
                <?php foreach (['todo', 'doing', 'done'] as $s): ?>
                    <option value="<?= esc($s) ?>" <?= old('status', $task['status'] ?? 'todo') === $s ? 'selected' : '' ?>><?= esc($s) ?></option>
                <?php endforeach; ?>
            </select>
        </div>
        <div class="col-md-6 mb-2"><label>Due Date</label><input type="date" class="form-control" name="due_date" value="<?= esc(old('due_date', $task['due_date'] ?? '')) ?>"></div>
        <div class="col-md-6 mb-2">
            <label>Assigned To</label>
            <select class="form-select" name="assigned_to">
                <option value="">Unassigned</option>
                <?php foreach ($staff as $u): ?>
                    <option value="<?= esc($u['id']) ?>" <?= old('assigned_to', $task['assigned_to'] ?? '') == $u['id'] ? 'selected' : '' ?>><?= esc($u['name']) ?></option>
                <?php endforeach; ?>
            </select>
        </div>
    </div>
    <?php if (isset($validation)): ?><div class="text-danger small mb-2"><?= $validation->listErrors() ?></div><?php endif; ?>
    <button class="btn btn-success">Save</button>
    <a class="btn btn-secondary" href="/admin/tasks">Back</a>
</form>
<?= $this->endSection() ?>
