<?= $this->extend('layouts/main') ?>
<?= $this->section('content') ?>
<div class="d-flex justify-content-between mb-3">
    <h3>Service Types</h3>
    <a class="btn btn-primary" href="/admin/service-types/create">New Service Type</a>
</div>

<table class="table table-bordered">
    <thead><tr><th>ID</th><th>Name</th><th>Active</th><th>Actions</th></tr></thead>
    <tbody>
    <?php foreach ($serviceTypes as $s): ?>
        <tr>
            <td><?= esc($s['id']) ?></td>
            <td><?= esc($s['name']) ?></td>
            <td><?= (int) $s['is_active'] === 1 ? 'Yes' : 'No' ?></td>
            <td>
                <a class="btn btn-sm btn-warning" href="/admin/service-types/<?= esc($s['id']) ?>/edit">Edit</a>
                <a class="btn btn-sm btn-danger" href="/admin/service-types/<?= esc($s['id']) ?>/delete" onclick="return confirm('Delete service type?')">Delete</a>
            </td>
        </tr>
    <?php endforeach; ?>
    </tbody>
</table>
<?= $this->endSection() ?>
