<?= $this->extend('layouts/main') ?>
<?= $this->section('content') ?>
<div class="d-flex justify-content-between mb-3">
    <h3>Projects</h3>
    <a class="btn btn-primary" href="/admin/projects/create">New Project</a>
</div>

<table class="table table-bordered">
    <thead><tr><th>ID</th><th>Name</th><th>Customer</th><th>Status</th><th>Dates</th><th>Actions</th></tr></thead>
    <tbody>
    <?php foreach ($projects as $p): ?>
        <tr>
            <td><?= esc($p['id']) ?></td>
            <td><?= esc($p['name']) ?></td>
            <td><?= esc($p['company_name']) ?></td>
            <td><?= esc($p['status']) ?></td>
            <td><?= esc($p['start_date']) ?> / <?= esc($p['due_date']) ?></td>
            <td>
                <a class="btn btn-sm btn-warning" href="/admin/projects/<?= esc($p['id']) ?>/edit">Edit</a>
                <a class="btn btn-sm btn-danger" href="/admin/projects/<?= esc($p['id']) ?>/delete" onclick="return confirm('Delete project?')">Delete</a>
            </td>
        </tr>
    <?php endforeach; ?>
    </tbody>
</table>
<?= $this->endSection() ?>
