<?= $this->extend('layouts/main') ?>
<?= $this->section('content') ?>
<h3><?= isset($project) && $project ? 'Edit Project' : 'Create Project' ?></h3>

<form method="post">
    <?= csrf_field() ?>
    <div class="row">
        <div class="col-md-6 mb-2">
            <label>Customer</label>
            <select class="form-select" name="customer_id" required>
                <option value="">Select</option>
                <?php foreach ($customers as $c): ?>
                    <option value="<?= esc($c['id']) ?>" <?= old('customer_id', $project['customer_id'] ?? '') == $c['id'] ? 'selected' : '' ?>><?= esc($c['company_name']) ?></option>
                <?php endforeach; ?>
            </select>
        </div>
        <div class="col-md-6 mb-2"><label>Name</label><input class="form-control" name="name" value="<?= esc(old('name', $project['name'] ?? '')) ?>" required></div>
        <div class="col-md-12 mb-2"><label>Description</label><textarea class="form-control" name="description"><?= esc(old('description', $project['description'] ?? '')) ?></textarea></div>
        <div class="col-md-4 mb-2">
            <label>Status</label>
            <select class="form-select" name="status">
                <?php foreach (['planned', 'active', 'done', 'cancelled'] as $s): ?>
                    <option value="<?= esc($s) ?>" <?= old('status', $project['status'] ?? 'planned') === $s ? 'selected' : '' ?>><?= esc($s) ?></option>
                <?php endforeach; ?>
            </select>
        </div>
        <div class="col-md-4 mb-2"><label>Start Date</label><input type="date" class="form-control" name="start_date" value="<?= esc(old('start_date', $project['start_date'] ?? '')) ?>"></div>
        <div class="col-md-4 mb-2"><label>Due Date</label><input type="date" class="form-control" name="due_date" value="<?= esc(old('due_date', $project['due_date'] ?? '')) ?>"></div>
    </div>
    <?php if (isset($validation)): ?><div class="text-danger small mb-2"><?= $validation->listErrors() ?></div><?php endif; ?>
    <button class="btn btn-success">Save</button>
    <a href="/admin/projects" class="btn btn-secondary">Back</a>
</form>
<?= $this->endSection() ?>
