<?= $this->extend('layouts/main') ?>
<?= $this->section('content') ?>
<h3><?= isset($customer) && $customer ? 'Edit Customer' : 'Create Customer' ?></h3>

<form method="post">
    <?= csrf_field() ?>
    <div class="row">
        <div class="col-md-6 mb-2"><label>Company</label><input class="form-control" name="company_name" value="<?= esc(old('company_name', $customer['company_name'] ?? '')) ?>" required></div>
        <div class="col-md-6 mb-2"><label>Contact</label><input class="form-control" name="contact_name" value="<?= esc(old('contact_name', $customer['contact_name'] ?? '')) ?>"></div>
        <div class="col-md-6 mb-2"><label>Phone</label><input class="form-control" name="phone" value="<?= esc(old('phone', $customer['phone'] ?? '')) ?>"></div>
        <div class="col-md-6 mb-2"><label>Email</label><input class="form-control" name="email" value="<?= esc(old('email', $customer['email'] ?? '')) ?>"></div>
        <div class="col-md-6 mb-2"><label>Tax Office</label><input class="form-control" name="tax_office" value="<?= esc(old('tax_office', $customer['tax_office'] ?? '')) ?>"></div>
        <div class="col-md-6 mb-2"><label>Tax Number</label><input class="form-control" name="tax_number" value="<?= esc(old('tax_number', $customer['tax_number'] ?? '')) ?>"></div>
        <div class="col-md-12 mb-2"><label>Address</label><textarea class="form-control" name="address"><?= esc(old('address', $customer['address'] ?? '')) ?></textarea></div>
        <div class="col-md-12 mb-2"><label>Notes</label><textarea class="form-control" name="notes"><?= esc(old('notes', $customer['notes'] ?? '')) ?></textarea></div>
        <div class="col-md-3 mb-2">
            <label>Active</label>
            <select class="form-select" name="is_active">
                <option value="1" <?= (int) old('is_active', $customer['is_active'] ?? 1) === 1 ? 'selected' : '' ?>>Yes</option>
                <option value="0" <?= (int) old('is_active', $customer['is_active'] ?? 1) === 0 ? 'selected' : '' ?>>No</option>
            </select>
        </div>
    </div>
    <?php if (isset($validation)): ?><div class="text-danger small mb-2"><?= $validation->listErrors() ?></div><?php endif; ?>
    <button class="btn btn-success">Save</button>
    <a href="/admin/customers" class="btn btn-secondary">Back</a>
</form>
<?= $this->endSection() ?>
