<?= $this->extend('layouts/main') ?>
<?= $this->section('content') ?>
<h3>Cash Transactions</h3>

<div class="row mb-3">
    <div class="col-md-4"><div class="card"><div class="card-body"><strong>Income</strong><div><?= number_format($income, 2) ?></div></div></div></div>
    <div class="col-md-4"><div class="card"><div class="card-body"><strong>Expense</strong><div><?= number_format($expense, 2) ?></div></div></div></div>
    <div class="col-md-4"><div class="card"><div class="card-body"><strong>Balance</strong><div><?= number_format($balance, 2) ?></div></div></div></div>
</div>

<form method="post" action="/admin/cash/create" class="row g-2 mb-3">
    <?= csrf_field() ?>
    <div class="col-md-2">
        <select class="form-select" name="type" required><option value="income">income</option><option value="expense">expense</option></select>
    </div>
    <div class="col-md-2"><input type="date" class="form-control" name="date" required></div>
    <div class="col-md-2"><input type="number" step="0.01" class="form-control" name="amount" placeholder="Amount" required></div>
    <div class="col-md-2"><input type="text" class="form-control" name="category" placeholder="Category" required></div>
    <div class="col-md-2">
        <select class="form-select" name="customer_id">
            <option value="">Customer</option>
            <?php foreach ($customers as $c): ?><option value="<?= esc($c['id']) ?>"><?= esc($c['company_name']) ?></option><?php endforeach; ?>
        </select>
    </div>
    <div class="col-md-2">
        <select class="form-select" name="project_id">
            <option value="">Project</option>
            <?php foreach ($projects as $p): ?><option value="<?= esc($p['id']) ?>"><?= esc($p['name']) ?></option><?php endforeach; ?>
        </select>
    </div>
    <div class="col-md-12"><textarea class="form-control" name="note" placeholder="Note"></textarea></div>
    <div class="col-md-12"><button class="btn btn-primary">Add Transaction</button></div>
</form>

<table class="table table-bordered table-sm">
    <thead><tr><th>Date</th><th>Type</th><th>Amount</th><th>Category</th><th>Customer</th><th>Project</th><th>Note</th></tr></thead>
    <tbody>
    <?php foreach ($transactions as $t): ?>
        <tr>
            <td><?= esc($t['date']) ?></td>
            <td><?= esc($t['type']) ?></td>
            <td><?= number_format((float) $t['amount'], 2) ?></td>
            <td><?= esc($t['category']) ?></td>
            <td><?= esc($t['company_name']) ?></td>
            <td><?= esc($t['project_name']) ?></td>
            <td><?= esc($t['note']) ?></td>
        </tr>
    <?php endforeach; ?>
    </tbody>
</table>
<?= $this->endSection() ?>
