<?php

namespace App\Controllers\Staff;

use App\Controllers\BaseController;
use App\Models\TaskModel;

class TasksController extends BaseController
{
    public function index()
    {
        $userId = (int) session()->get('user_id');

        $tasks = (new TaskModel())
            ->select('tasks.*, projects.name AS project_name, customers.company_name, service_types.name AS service_type_name')
            ->join('projects', 'projects.id = tasks.project_id')
            ->join('customers', 'customers.id = projects.customer_id', 'left')
            ->join('service_types', 'service_types.id = tasks.service_type_id')
            ->where('tasks.assigned_to', $userId)
            ->orderBy('tasks.due_date', 'asc')
            ->findAll();

        return $this->render('staff/tasks/index', ['tasks' => $tasks]);
    }

    public function show(int $id)
    {
        $userId = (int) session()->get('user_id');

        $task = (new TaskModel())
            ->select('tasks.*, projects.name AS project_name, customers.company_name, service_types.name AS service_type_name')
            ->join('projects', 'projects.id = tasks.project_id')
            ->join('customers', 'customers.id = projects.customer_id', 'left')
            ->join('service_types', 'service_types.id = tasks.service_type_id')
            ->where('tasks.id', $id)
            ->where('tasks.assigned_to', $userId)
            ->first();

        if (! $task) {
            return redirect()->to('/staff/my-tasks')->with('error', 'Task not found.');
        }

        return $this->render('staff/tasks/show', ['task' => $task]);
    }

    public function updateStatus(int $id)
    {
        $rules = ['status' => 'required|in_list[todo,doing,done]'];
        if (! $this->validate($rules)) {
            return redirect()->back()->with('error', 'Invalid status.');
        }

        $userId = (int) session()->get('user_id');
        $taskModel = new TaskModel();
        $task = $taskModel->where('id', $id)->where('assigned_to', $userId)->first();

        if (! $task) {
            return redirect()->to('/staff/my-tasks')->with('error', 'Task not found.');
        }

        $taskModel->update($id, ['status' => $this->request->getPost('status')]);

        return redirect()->to('/staff/tasks/' . $id)->with('success', 'Status updated.');
    }
}
