<?php

namespace App\Controllers;

use CodeIgniter\Controller;

abstract class BaseController extends Controller
{
    protected $request;
    protected $helpers = ['form', 'url'];

    protected function render(string $view, array $data = [])
    {
        $data['currentUser'] = [
            'id'   => session()->get('user_id'),
            'name' => session()->get('name'),
            'role' => session()->get('role'),
        ];

        return view($view, $data);
    }
}
