<?php

namespace App\Controllers;

use App\Models\UserModel;

class AuthController extends BaseController
{
    public function login()
    {
        if (session()->get('user_id')) {
            return redirect()->to(session()->get('role') === 'admin' ? '/admin/dashboard' : '/staff/my-tasks');
        }

        if ($this->request->getMethod() === 'post') {
            $rules = [
                'email'    => 'required|valid_email',
                'password' => 'required|min_length[6]',
            ];

            if (! $this->validate($rules)) {
                return $this->render('auth/login', ['validation' => $this->validator]);
            }

            $user = (new UserModel())->where('email', $this->request->getPost('email'))->first();

            if (! $user || (int) $user['is_active'] !== 1 || ! password_verify((string) $this->request->getPost('password'), $user['password_hash'])) {
                return redirect()->back()->withInput()->with('error', 'Invalid credentials.');
            }

            session()->set([
                'user_id' => $user['id'],
                'name'    => $user['name'],
                'role'    => $user['role'],
            ]);

            return redirect()->to($user['role'] === 'admin' ? '/admin/dashboard' : '/staff/my-tasks');
        }

        return $this->render('auth/login');
    }

    public function logout()
    {
        session()->destroy();
        return redirect()->to('/login')->with('success', 'Logged out.');
    }
}
