<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController;
use App\Models\UserModel;

class UsersController extends BaseController
{
    public function index()
    {
        $users = (new UserModel())->orderBy('id', 'desc')->findAll();
        return $this->render('admin/users/index', ['users' => $users]);
    }

    public function create()
    {
        if ($this->request->getMethod() === 'post') {
            $rules = [
                'name'     => 'required|min_length[2]',
                'email'    => 'required|valid_email|is_unique[users.email]',
                'password' => 'required|min_length[6]',
                'role'     => 'required|in_list[admin,staff]',
            ];

            if (! $this->validate($rules)) {
                return $this->render('admin/users/form', ['validation' => $this->validator]);
            }

            (new UserModel())->insert([
                'name'          => $this->request->getPost('name'),
                'email'         => $this->request->getPost('email'),
                'password_hash' => password_hash((string) $this->request->getPost('password'), PASSWORD_DEFAULT),
                'role'          => $this->request->getPost('role'),
                'is_active'     => 1,
            ]);

            return redirect()->to('/admin/users')->with('success', 'User created.');
        }

        return $this->render('admin/users/form');
    }

    public function toggle(int $id)
    {
        $model = new UserModel();
        $user = $model->find($id);

        if (! $user) {
            return redirect()->to('/admin/users')->with('error', 'User not found.');
        }

        if ((int) $user['id'] === (int) session()->get('user_id')) {
            return redirect()->to('/admin/users')->with('error', 'You cannot toggle your own account.');
        }

        $model->update($id, ['is_active' => (int) $user['is_active'] === 1 ? 0 : 1]);

        return redirect()->to('/admin/users')->with('success', 'User status updated.');
    }
}
