<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController;
use App\Models\ServiceTypeModel;

class ServiceTypesController extends BaseController
{
    public function index()
    {
        $serviceTypes = (new ServiceTypeModel())->orderBy('id', 'desc')->findAll();
        return $this->render('admin/service_types/index', ['serviceTypes' => $serviceTypes]);
    }

    public function create()
    {
        if ($this->request->getMethod() === 'post') {
            $rules = ['name' => 'required|min_length[2]|is_unique[service_types.name]'];
            if (! $this->validate($rules)) {
                return $this->render('admin/service_types/form', ['serviceType' => null, 'validation' => $this->validator]);
            }

            (new ServiceTypeModel())->insert([
                'name'      => $this->request->getPost('name'),
                'is_active' => $this->request->getPost('is_active') ? 1 : 0,
            ]);

            return redirect()->to('/admin/service-types')->with('success', 'Service type created.');
        }

        return $this->render('admin/service_types/form', ['serviceType' => null]);
    }

    public function edit(int $id)
    {
        $model = new ServiceTypeModel();
        $serviceType = $model->find($id);

        if (! $serviceType) {
            throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
        }

        if ($this->request->getMethod() === 'post') {
            $rules = ['name' => 'required|min_length[2]|is_unique[service_types.name,id,' . $id . ']'];
            if (! $this->validate($rules)) {
                return $this->render('admin/service_types/form', ['serviceType' => $serviceType, 'validation' => $this->validator]);
            }

            $model->update($id, [
                'name'      => $this->request->getPost('name'),
                'is_active' => $this->request->getPost('is_active') ? 1 : 0,
            ]);

            return redirect()->to('/admin/service-types')->with('success', 'Service type updated.');
        }

        return $this->render('admin/service_types/form', ['serviceType' => $serviceType]);
    }

    public function delete(int $id)
    {
        (new ServiceTypeModel())->delete($id);
        return redirect()->to('/admin/service-types')->with('success', 'Service type deleted.');
    }
}
