<?php

use CodeIgniter\Router\RouteCollection;

/**
 * @var RouteCollection $routes
 */
$routes->get('/', static fn() => redirect()->to('/login'));

$routes->match(['get', 'post'], 'install', 'InstallController::index');

$routes->match(['get', 'post'], 'login', 'AuthController::login');
$routes->get('logout', 'AuthController::logout', ['filter' => 'auth']);

$routes->group('admin', ['filter' => 'auth'], static function ($routes) {
    $routes->get('dashboard', 'Admin\\DashboardController::index', ['filter' => 'admin']);

    $routes->get('customers', 'Admin\\CustomersController::index', ['filter' => 'admin']);
    $routes->match(['get', 'post'], 'customers/create', 'Admin\\CustomersController::create', ['filter' => 'admin']);
    $routes->match(['get', 'post'], 'customers/(:num)/edit', 'Admin\\CustomersController::edit/$1', ['filter' => 'admin']);
    $routes->get('customers/(:num)', 'Admin\\CustomersController::show/$1', ['filter' => 'admin']);
    $routes->post('customers/(:num)/invoices/create', 'Admin\\CustomersController::createInvoice/$1', ['filter' => 'admin']);
    $routes->post('customers/(:num)/payments/create', 'Admin\\CustomersController::createPayment/$1', ['filter' => 'admin']);

    $routes->get('projects', 'Admin\\ProjectsController::index', ['filter' => 'admin']);
    $routes->match(['get', 'post'], 'projects/create', 'Admin\\ProjectsController::create', ['filter' => 'admin']);
    $routes->match(['get', 'post'], 'projects/(:num)/edit', 'Admin\\ProjectsController::edit/$1', ['filter' => 'admin']);
    $routes->get('projects/(:num)/delete', 'Admin\\ProjectsController::delete/$1', ['filter' => 'admin']);

    $routes->get('tasks', 'Admin\\TasksController::index', ['filter' => 'admin']);
    $routes->match(['get', 'post'], 'tasks/create', 'Admin\\TasksController::create', ['filter' => 'admin']);
    $routes->match(['get', 'post'], 'tasks/(:num)/edit', 'Admin\\TasksController::edit/$1', ['filter' => 'admin']);

    $routes->get('service-types', 'Admin\\ServiceTypesController::index', ['filter' => 'admin']);
    $routes->match(['get', 'post'], 'service-types/create', 'Admin\\ServiceTypesController::create', ['filter' => 'admin']);
    $routes->match(['get', 'post'], 'service-types/(:num)/edit', 'Admin\\ServiceTypesController::edit/$1', ['filter' => 'admin']);
    $routes->get('service-types/(:num)/delete', 'Admin\\ServiceTypesController::delete/$1', ['filter' => 'admin']);

    $routes->get('cash', 'Admin\\CashController::index', ['filter' => 'admin']);
    $routes->post('cash/create', 'Admin\\CashController::create', ['filter' => 'admin']);

    $routes->get('users', 'Admin\\UsersController::index', ['filter' => 'admin']);
    $routes->match(['get', 'post'], 'users/create', 'Admin\\UsersController::create', ['filter' => 'admin']);
    $routes->get('users/(:num)/toggle', 'Admin\\UsersController::toggle/$1', ['filter' => 'admin']);
});

$routes->group('staff', ['filter' => 'auth'], static function ($routes) {
    $routes->get('my-tasks', 'Staff\\TasksController::index', ['filter' => 'staff']);
    $routes->get('tasks/(:num)', 'Staff\\TasksController::show/$1', ['filter' => 'staff']);
    $routes->post('tasks/(:num)/status', 'Staff\\TasksController::updateStatus/$1', ['filter' => 'staff']);
});
