<?php

namespace Config;

use CodeIgniter\Config\BaseConfig;
use CodeIgniter\Filters\CSRF;
use CodeIgniter\Filters\DebugToolbar;
use App\Filters\AuthFilter;
use App\Filters\AdminFilter;
use App\Filters\StaffFilter;

class Filters extends BaseConfig
{
    public array $aliases = [
        'csrf'    => CSRF::class,
        'toolbar' => DebugToolbar::class,
        'auth'    => AuthFilter::class,
        'admin'   => AdminFilter::class,
        'staff'   => StaffFilter::class,
    ];

    public array $globals = [
        'before' => [
            'csrf',
        ],
        'after' => [
            'toolbar',
        ],
    ];

    public array $methods = [];
    public array $filters = [];
}
